# Generated by Django 5.1.2 on 2024-12-23 04:03

import django.db.models.deletion
import turnos.models
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('turnos', '0028_turnos_fecha_aprobacion'),
    ]

    operations = [
        migrations.RenameField(
            model_name='inspectores',
            old_name='idAgencia',
            new_name='agencia',
        ),
        migrations.RenameField(
            model_name='inspectores',
            old_name='externo',
            new_name='esta_habilitado',
        ),
        migrations.RemoveField(
            model_name='inspectores',
            name='apellidoMaterno',
        ),
        migrations.RemoveField(
            model_name='inspectores',
            name='apellidoPaterno',
        ),
        migrations.RemoveField(
            model_name='inspectores',
            name='extranjero',
        ),
        migrations.RemoveField(
            model_name='inspectores',
            name='habilitado',
        ),
        migrations.RemoveField(
            model_name='inspectores',
            name='imagenPath',
        ),
        migrations.RemoveField(
            model_name='inspectores',
            name='tipo',
        ),
        migrations.AddField(
            model_name='inspectores',
            name='apellido_materno',
            field=models.CharField(blank=True, max_length=255),
        ),
        migrations.AddField(
            model_name='inspectores',
            name='apellido_paterno',
            field=models.CharField(default=1, max_length=255),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='inspectores',
            name='es_externo',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='inspectores',
            name='es_extranjero',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='inspectores',
            name='foto',
            field=models.ImageField(blank=True, upload_to=turnos.models.documento_inspector_upload_to),
        ),
        migrations.AddField(
            model_name='inspectores',
            name='tipo_inspector',
            field=models.CharField(choices=[('profesional', 'Profesional'), ('practico', 'Practico'), ('junior', 'Junior')], default=1, max_length=12),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='inspectores',
            name='celular',
            field=models.CharField(blank=True, default=1, max_length=15),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='inspectores',
            name='email',
            field=models.EmailField(blank=True, default=1, max_length=255),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='inspectores',
            name='genero',
            field=models.CharField(blank=True, default=1, max_length=25),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='inspectores',
            name='nombre',
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name='inspectores',
            name='rut',
            field=models.CharField(max_length=10, unique=True),
        ),
        migrations.CreateModel(
            name='DocumentosInspector',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('documento', models.FileField(blank=True, null=True, upload_to=turnos.models.documento_inspector_upload_to)),
                ('tipo_documento', models.CharField(choices=[('riohs', 'Registro RIOHS'), ('odi', 'Registro ODI'), ('cedula_frontal', 'Cedula Frontal'), ('cedula_reverso', 'Cedula Reverso'), ('antecedentes', 'Certificado Antecedentes')], max_length=15)),
                ('fecha_firma', models.DateField(blank=True, null=True)),
                ('estado', models.CharField(choices=[('vigente', 'Vigente'), ('vencido', 'Vencido'), ('en proceso', 'En proceso')], default='no registra', max_length=15)),
                ('usuario_ingresa', models.EmailField(blank=True, max_length=115, null=True)),
                ('inspector', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='turnos.inspectores')),
            ],
            options={
                'db_table': 'documento_eventual',
            },
        ),
        migrations.CreateModel(
            name='HistorialInspectores',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('usuario_email', models.EmailField(blank=True, max_length=255, null=True)),
                ('fecha', models.DateTimeField(auto_now_add=True)),
                ('accion', models.CharField(max_length=255)),
                ('detalles', models.TextField(blank=True)),
                ('inspector', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='historial_inspector', to='turnos.inspectores')),
            ],
            options={
                'db_table': 'historial_inspectores',
                'ordering': ['-fecha'],
            },
        ),
    ]
